import { Camera, Mail, Phone, MapPin, Clock } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Camera size={28} strokeWidth={2} className="footer-logo-icon" />
              <h2 className="footer-logo-text">StudioSpace</h2>
            </div>
            <p className="footer-description">
              Профессиональные фотостудии для ваших творческих проектов.
            </p>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={18} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={18} strokeWidth={2} />
                <a href="mailto:info@studiospace.ru">info@studiospace.ru</a>
              </li>
              <li>
                <MapPin size={18} strokeWidth={2} />
                <span>г. Москва, ул. Студийная, д. 15</span>
              </li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Типы студий</h3>
            <ul className="footer-links">
              <li><a href="#">Студия с фоном</a></li>
              <li><a href="#">Хромакей</a></li>
              <li><a href="#">Интерьер</a></li>
              <li><a href="#">Open Space</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Режим работы</h3>
            <ul className="footer-links">
              <li>
                <Clock size={16} strokeWidth={2} />
                <span>Пн-Вс: 8:00 - 24:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 StudioSpace. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

